#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
/* Generated code for model Input */
namespace openplx::Physics::Signals {
    /**
     * An Input, ie a receiver of signals.
     * - Each Input should have a type-attribute, e.g. InputOutputType.Torque1D, Angle, AngularVelocity or any of above.
     * - Use type Composite when the Input receives a Signal with multiple values.
     * - reference_id is optional and must be unique within each Robot and can be used to identify the sensor, e.g. when communicating using Click or ROS. Typically the full name will be used if not set.
     **/
    class Input : public openplx::Core::Object {
        protected:
            int64_t m_type;
            std::string m_reference_id;

        public:
            Input();
            int64_t type() const;
            std::string reference_id() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
