#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/BoolOutput.h>
/* Generated code for model EngagedOutput */
namespace openplx::Physics::Signals {
    /**
     * An Output that is a boolean, answering if the source is engaged or not.
     * Not to be mistaken for ActivatedOutput. For example a clutch can be engaged, but not activated.
     * A vacuum gripper can be activated, but is not engaged until an object is in the gripper.
     **/
    class EngagedOutput : public openplx::Physics::Signals::BoolOutput {
        protected:

        public:
            EngagedOutput();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
