#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/BoolInput.h>
/* Generated code for model EngageInput */
namespace openplx::Physics::Signals {
    /**
     * An Input that is a boolean, specifying weather to engage or disengage the source.
     * Not to be mistaken for ActivateInput. For example a clutch can be engaged, but not activated.
     * A vacuum gripper can be activated, but is not engaged until an object is in the gripper.
     **/
    class EngageInput : public openplx::Physics::Signals::BoolInput {
        protected:

        public:
            EngageInput();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
