#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/Input.h>
#include <openplx/Physics/Signals/AngularVelocity1DInputTrait.h>
/* Generated code for model AngularVelocity1DInput */
namespace openplx::Physics::Signals {
    /**
     * A scalar angular velocity input given an interaction.
     * For interactions where it is unambiguous which angular velocity is considered,
     * the input will update that value.
     **/
    class AngularVelocity1DInput : public openplx::Physics::Signals::Input {
        protected:
            std::weak_ptr<openplx::Physics::Signals::AngularVelocity1DInputTrait> m_source;

        public:
            AngularVelocity1DInput();
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
