#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Toughness/DefaultToughness.h>
/* Generated code for model ThresholdFracture */
namespace openplx::Physics::Interactions::Toughness {
    /**
     *     Defines an interaction or material to break at a specific stress limit,
     *     the fracture_point.
     *     Force for linear, torque for angular. 
     *     */
    class ThresholdFracture : public openplx::Physics::Interactions::Toughness::DefaultToughness {
        protected:
            double m_fracture_point;

        public:
            ThresholdFracture();
            double fracture_point() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
