
#pragma once

#include <openplx/NodeVisitor.h>
#include <openplx/AnalysisContext.h>

namespace openplx
{
    /**
     * Implements pass 1 of semantic analysis as described in developer/BrickSemanticAnalysis.md
     */
    class Pass1Visitor : public NodeVisitor
    {
        public:

            explicit Pass1Visitor(Analysis::AnalysisContext* context) : m_context(context) {}

            void visitDocument(const DocPtr &document) override;

            void visitModelDeclaration(const ModelDeclPtr &model_declaration) override;

            void visitVarAssignment(const VarAssignPtr &var_assignment) override;

            void visitMethodDeclaration(const MethodDeclPtr &method_declaration) override;

            void visitParameter(const ParamPtr &parameter) override;

            void visitOperatorOverload(const OpOverloadPtr &op_overload) override;

            void visitTraitImpl(const TraitImplPtr& trait) override;

        private:

            void reportError(error_code_t error_code, const Token& first_token, const Token& last_token);
            void reportError(error_code_t error_code, const Token& token);
            void reportError(error_code_t error_code, const std::vector<Token>& segments);
            void reportError(std::shared_ptr<Error>&& error);

            Analysis::AnalysisContext* m_context;

            DocPtr m_document;
            ModelDeclPtr m_model;
    };
}
