
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>

namespace openplx
{
    class Parameter : public Node, public std::enable_shared_from_this<Parameter>
    {
        public:
            /* Factories */
            static ParamPtr create(const Token& name_token, const std::vector<Token>& type_segments);

            /* Overrides */
            ParamPtr asParameter() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;

            /* Name */
            const Token& getNameToken() const;
            const std::string& getName() const;

            /* Type */
            const std::vector<Token>& getTypeSegments() const;
            TypePtr getType() const;
            void setType(TypePtr type);

        private:
            Parameter();
            Token m_name_token;
            std::vector<Token> m_type_segments;
            TypePtr m_type;
    };
}
