
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Type.h>

namespace openplx
{
    class MethodDeclaration : public Type, public std::enable_shared_from_this<MethodDeclaration>
    {
        public:
            /* Factories */
            static MethodDeclPtr create(
                const Token& qualifier_token,
                const Token& name_token,
                const std::vector<ParamPtr>& parameters,
                const std::vector<Token>& return_type_segments);

            /* Overrides */
            MethodDeclPtr asMethodDeclaration() override;
            void accept(NodeVisitor& visitor) override;
            std::string toString() override;
            std::string toKey() override;
            bool isAssignableTo(const TypePtr &other) override;
            void unbind() override;

            /* Qualifier */
            Token getQualifierToken() const;
            bool isStatic() const;

            /* Name */
            const Token& getNameToken() const;
            const std::string& getName() const;

            /* Parameters */
            const std::vector<ParamPtr>& getParameters() const;
            void appendToParameters(ParamPtr parameter);

            /* Return type */
            const std::vector<Token>& getReturnTypeSegments() const;
            TypePtr getReturnType() const;
            void setReturnType(TypePtr return_type);

            /* Source id */
            std::string getSourceIdOrDefault() const;

            /* Owning model */
            ModelDeclPtr getOwningModel() const;
            void setOwningModel(ModelDeclPtr owning_model);

        private:
            MethodDeclaration();
            Token m_qualifier_token;
            Token m_name_token;
            std::vector<ParamPtr> m_parameters;
            std::vector<Token> m_return_type_segments;
            TypePtr m_return_type;
            ModelDeclPtr m_owning_model;
    };
}
