
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Expression.h>

namespace openplx
{
    class MemberAccess : public Expression, public std::enable_shared_from_this<MemberAccess>
    {
        public:
            /* Factories */
            static MemberAccessPtr create(ExprPtr receiver, const Token& member_token);

            /* Overrides */
            MemberAccessPtr asMemberAccess() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;
            ExprPtr clone() override;
            bool isReference() override;

            /* Member */
            Token getMemberToken() const;
            NodePtr getMember() const;
            void setMember(NodePtr member);

            /* Receiver */
            ExprPtr getReceiver() const;
            void setReceiver(ExprPtr receiver);

            /* Utility */
            bool isConst() const;
            VarAssignPtr lookupDeclarationFromSegments(const std::vector<Token>& segments, size_t offset);

            /**
             * Methods that works on "flat" member accesses, i.e. member accesses with just
             * identifiers, e.g. foo.bar.x, not foo.call().x or (a + b).x
             */
            bool isFlat() const;
            void flattenInto(std::vector<std::string>& output) const;
            void flattenTokensInto(std::vector<Token>& output, bool skip_this = false) const;
            size_t flatLength() const;
            std::string toFlatString(bool skip_last = false, bool skip_this = false) const;


        private:
            MemberAccess();
            Token m_member_token;
            NodePtr m_member;
            ExprPtr m_receiver;
    };
}
