#pragma once

#include <vector>
#include <unordered_set>
#include <openplx/NodeVisitor.h>
#include <openplx/Token.h>

namespace openplx {

    class ErrorReporter;
    class Document;
    class ModelDeclaration;

    /**
     * Validates all traits in a document
     */
    class InheritanceLoopDetector : private NodeVisitor {
        public:
            InheritanceLoopDetector(std::shared_ptr<ErrorReporter> error_reporter);
            bool validate(const std::shared_ptr<Document>& document);

        private:
            void visitDocument(const std::shared_ptr<Document>& document) override;
            void visitModelDeclaration(const std::shared_ptr<ModelDeclaration>& model_declaration) override;

            void reportUniqueErrors();

            std::shared_ptr<ErrorReporter> m_error_reporter;
            std::vector<std::vector<std::shared_ptr<ModelDeclaration>>> m_loops;
            std::unordered_set<std::string> m_reported;
    };
}
