#pragma once

#include <ostream>
#include <string>
#include <functional>

namespace is
{
    using endl_type = std::ostream& (*)(std::ostream&);

    class IndentedStream
    {
        public:
            int indentLevel;
            bool doIndent;
            std::ostream os;

            IndentedStream(std::ostream &ostr) :
                indentLevel(0),
                doIndent(false),
                os(ostr.rdbuf()),
                indent_str("    ")
            {}

            IndentedStream(std::ostream &ostr, const char* istr) :
                    indentLevel(0),
                    doIndent(false),
                    os(ostr.rdbuf()),
                    indent_str(istr)
            {}

            
            IndentedStream &operator<<(bool v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(char v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(unsigned char v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(short v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(unsigned short v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(int v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(unsigned int v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(long v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(unsigned long v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(long long v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(unsigned long long v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(float v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(double v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(long double v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(const void *v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(const char *v) {add_indent(); os << v;return *this;}
            IndentedStream &operator<<(const std::string &v) {add_indent(); os << v;return *this;}
                        
            // Handle std::endl
            IndentedStream& operator<<(endl_type probably_endl)
            {
                this->os << probably_endl;
                if (probably_endl == static_cast<endl_type>(std::endl))
                    this->doIndent = true;
                return *this;
            }

            /**
             * @brief Indents block in lambda, use with `[&] {code...}`
             * 
             * @param indented_block_lambda the lambda containing the code
             * @return IndentedStream& 
             */
            IndentedStream& operator<<(const std::function<void()>& indented_block_lambda)
            {
                this->indentLevel += 1;
                this->doIndent = true;
                this->os << std::endl;
                indented_block_lambda();
                this->indentLevel -= 1;
                this->doIndent = true;
                return *this;
            }

        private:
            void add_indent() {
                if (doIndent) {
                    for (int i = 0; i < this->indentLevel; i++) {
                        this->os << indent_str;
                    }
                }
                doIndent = false;
            }

            const char* indent_str;
    };
}
