#pragma once

#include <vector>
#include <string>
#include <openplx/Error.h>

namespace openplx {

    class ErrorReporter {
        public:
            ~ErrorReporter() = default;

            void reportError(std::shared_ptr<Error> error);
            /**
             * @deprecated will be moved to subclass
             */

            Errors::const_iterator begin() const;

            Errors::const_iterator end() const;

            size_t getErrorCount() const;
            const Errors& getErrors() const;

        private:
            Errors m_errors;
    };
}
