#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics1D/Interactions/Mate.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/FractionInputTrait.h>
#include <openplx/Physics/Signals/FractionOutputTrait.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
#include <openplx/Physics/Signals/FractionInput.h>
#include <openplx/Physics/Signals/FractionOutput.h>
/* Generated code for model Gear */
namespace openplx::DriveTrain {
    /**
     * The Gear serves as a rotational coupling between two RotationalBodies.
     * It establishes a linear relationship between the rotational speed and position
     * of the two Physics1D.Bodies.RotationalBody instances through a specified gear ratio.
     * This model assumes an ideal gear, characterized by no slippage or flexibility.
     **/
    class Gear : public openplx::Physics1D::Interactions::Mate, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::FractionInputTrait, public openplx::Physics::Signals::FractionOutputTrait {
        protected:
            double m_ratio;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> m_ratio_input;
            std::shared_ptr<openplx::Physics::Signals::FractionOutput> m_ratio_output;

        public:
            Gear();
            double ratio() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> ratio_input() const;
            std::shared_ptr<openplx::Physics::Signals::FractionOutput> ratio_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
