#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics1D/Interactions/Mate.h>
#include <openplx/DriveTrain/Shaft.h>
#include <openplx/Physics/Signals/BoolOutput.h>
#include <openplx/Physics/Signals/BoolInput.h>
/* Generated code for model Differential */
namespace openplx::DriveTrain {
    /**
     *     The differential in a vehicle transmit torque from the drive_shaft to the left_axle_shaft and right_axle_shaft.
     *     The default definition is that it will connect the output connector of the drive_shaft to the differential
     *     so that the differential transmitts torque to the input connectors of the axle shafts.
     *
     *     The gear_ratio in a vehicle's differential is the difference between the number of times the drive shaft
     *     needs to rotate in comparison to the axle_shafts.
     *     */
    class Differential : public openplx::Physics1D::Interactions::Mate {
        protected:
            std::shared_ptr<openplx::DriveTrain::Shaft> m_drive_shaft;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_left_axle_shaft;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_right_axle_shaft;
            double m_gear_ratio;
            bool m_locked_up;
            std::shared_ptr<openplx::Physics::Signals::BoolOutput> m_locked_up_output;
            std::shared_ptr<openplx::Physics::Signals::BoolInput> m_lock_up_input;

        public:
            Differential();
            std::shared_ptr<openplx::DriveTrain::Shaft> drive_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> left_axle_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> right_axle_shaft() const;
            double gear_ratio() const;
            bool locked_up() const;
            std::shared_ptr<openplx::Physics::Signals::BoolOutput> locked_up_output() const;
            std::shared_ptr<openplx::Physics::Signals::BoolInput> lock_up_input() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
