
#pragma once

#include <filesystem>
#include <string>
#include <openplx/BundleConfig.h>
#include <openplx/ErrorReporter.h>
#include <openplx/Document.h>

namespace openplx {
    struct DocumentContext {
        Bundle::BundleConfig bundle;
        std::filesystem::path path;
        std::string source;
        DocPtr document;

        DocumentContext(std::string s, std::filesystem::path p, Bundle::BundleConfig b)
            : bundle(b), path(p), source(std::move(s)) {}

        DocumentContext(std::string s, std::filesystem::path p, Bundle::BundleConfig b, const DocPtr& document)
                : bundle(b), path(p), source(std::move(s)), document(std::move(document)) {}
    };
}
