
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Expression.h>

namespace openplx
{
    /**
     * Represents leafs in the expressions: primaries (Real, Bool, String), and lone Identifiers.
     *
     */
    class Constant : public Expression, public std::enable_shared_from_this<Constant>
    {
        public:
            /* Factories */
            static ConstantPtr create(const Token& token);

            /* Overrides */
            ConstantPtr asConstant() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;
            ExprPtr clone() override;
            bool isReference() override;

            /* Token */
            Token getToken() const;

            /* Bound node */
            NodePtr getBoundNode() const;
            void setBoundNode(NodePtr bound_node);

            /* Utility */
            /**
             * Return string value or empty string if Constant is not a string
             * @return
             */
            std::string asString() const;
            bool isInt() const;

        private:
            Constant();
            Token m_token;
            NodePtr m_bound_node;
    };
}
