
#pragma once

#include <openplx/NodeVisitor.h>
#include <openplx/SymbolTree.h>
#include <openplx/PrimitiveType.h>
#include <openplx/AnalysisContext.h>

namespace openplx {
    /**
     * Set's the type of all expressions using a SymbolTree for lookups
     */
    class BindExpressionTypesVisitor : private NodeVisitor {
        public:
            BindExpressionTypesVisitor(std::shared_ptr<Analysis::AnalysisContext> context, std::shared_ptr<ErrorReporter> error_reporter);
            void bind(DocPtr document);
            void bind(ModelDeclPtr model);
            void bind(VarAssignPtr var);
        private:
            void visitDocument(const DocPtr& document) override;
            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;
            void visitVarAssignment(const VarAssignPtr& var_assignment) override;
            void visitConstant(const ConstantPtr& constant) override;
            void visitCall(const CallPtr& call) override;
            void visitMemberAccess(const MemberAccessPtr& member_access) override;
            void visitArray(const ArrayPtr& array) override;
            void visitUnary(const UnaryPtr& unary) override;
            void visitBinaryOp(const BinaryOpPtr& binary_op) override;
            void visitIndexing(const IndexingPtr& indexing) override;
            void visitAnnotation(const AnnotationPtr& annotation) override;
            void visitTraitImpl(const TraitImplPtr& trait_impl) override;
            void visitInitializer(const InitializerPtr& initializer) override;

            void reportError(error_code_t error_code, line_t line, col_t column);
            void reportError(error_code_t error_code, const Token& first_token, const Token& last_token);
            void reportError(error_code_t error_code, const Token& token);
            void reportError(error_code_t error_code, const std::vector<Token>& segments);
            void reportError(std::shared_ptr<Error>&& error);

            std::shared_ptr<ErrorReporter> m_error_reporter;
            std::shared_ptr<Analysis::AnalysisContext> m_context;
            DocPtr m_document;
            TopoPathPtr m_path;

            PrimitiveTypePtr m_primitive_type_real;
            PrimitiveTypePtr m_primitive_type_string;
            PrimitiveTypePtr m_primitive_type_bool;
            PrimitiveTypePtr m_primitive_type_int;
    };
}
