%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Terrain/Terrain_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Terrain::MaterialLibrary::defaultTerrainMaterial;
%nspace openplx::Terrain::MaterialLibrary::dirt_1;
%nspace openplx::Terrain::MaterialLibrary::gravel_1;
%nspace openplx::Terrain::MaterialLibrary::iron_pellets;
%nspace openplx::Terrain::MaterialLibrary::sand_1;
%nspace openplx::Terrain::MaterialLibrary::wet_sand;
%nspace openplx::Terrain::Shovel;
%nspace openplx::Terrain::Terrain;
%nspace openplx::Terrain::TerrainMaterial;
%shared_ptr(openplx::Terrain::MaterialLibrary::defaultTerrainMaterial);
%shared_ptr(openplx::Terrain::MaterialLibrary::dirt_1);
%shared_ptr(openplx::Terrain::MaterialLibrary::gravel_1);
%shared_ptr(openplx::Terrain::MaterialLibrary::iron_pellets);
%shared_ptr(openplx::Terrain::MaterialLibrary::sand_1);
%shared_ptr(openplx::Terrain::MaterialLibrary::wet_sand);
%shared_ptr(openplx::Terrain::Shovel);
%shared_ptr(openplx::Terrain::Terrain);
%shared_ptr(openplx::Terrain::TerrainMaterial);
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::MaterialLibrary::defaultTerrainMaterial)
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::MaterialLibrary::dirt_1)
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::MaterialLibrary::gravel_1)
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::MaterialLibrary::iron_pellets)
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::MaterialLibrary::sand_1)
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::MaterialLibrary::wet_sand)
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::Shovel)
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::Terrain)
OPENPLX_FIX_DOWNCASTING(openplx::Terrain::TerrainMaterial)
%include "openplx/Terrain/TerrainMaterial.h"
%include "openplx/Terrain/MaterialLibrary/defaultTerrainMaterial.h"
%include "openplx/Terrain/MaterialLibrary/dirt_1.h"
%include "openplx/Terrain/MaterialLibrary/gravel_1.h"
%include "openplx/Terrain/MaterialLibrary/iron_pellets.h"
%include "openplx/Terrain/MaterialLibrary/sand_1.h"
%include "openplx/Terrain/MaterialLibrary/wet_sand.h"
%include "openplx/Terrain/Shovel.h"
%include "openplx/Terrain/Terrain.h"
%ignore Terrain_register_factories;
%include <openplx/Terrain/Terrain_all.h>
%inline {
    void Terrain_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Terrain_register_factories(eval_ctx);
    }
}
%template(TerrainMaterialLibrarydefaultTerrainMaterialVector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::defaultTerrainMaterial>>;
%template(TerrainMaterialLibrarydirt_1Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::dirt_1>>;
%template(TerrainMaterialLibrarygravel_1Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::gravel_1>>;
%template(TerrainMaterialLibraryiron_pelletsVector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::iron_pellets>>;
%template(TerrainMaterialLibrarysand_1Vector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::sand_1>>;
%template(TerrainMaterialLibrarywet_sandVector) std::vector<std::shared_ptr<openplx::Terrain::MaterialLibrary::wet_sand>>;
%template(TerrainShovelVector) std::vector<std::shared_ptr<openplx::Terrain::Shovel>>;
%template(TerrainTerrainVector) std::vector<std::shared_ptr<openplx::Terrain::Terrain>>;
%template(TerrainTerrainMaterialVector) std::vector<std::shared_ptr<openplx::Terrain::TerrainMaterial>>;
