/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxTerrain/Shovel.h>
#include <agxTerrain/AggregateContactGenerator.h>
#include <agxTerrain/ShovelAggregateContactUtils.h>
#include <agxTerrain/TerrainFrictionModels.h>
#include <agxTerrain/DeformController.h>

#include <agxStream/Serializable.h>

namespace agxTerrain
{
  namespace deprecated
  {
    AGX_DECLARE_POINTER_TYPES(TerrainToolCollection);
    AGX_DECLARE_VECTOR_TYPES(TerrainToolCollection);

    /**
    Collection of terrain tool (currently Shovel) related objects which are
    terrain instance specific.
    */
    class AGXTERRAIN_EXPORT TerrainToolCollection : public agx::Referenced, public agxStream::Serializable
    {
    public:

      // --- DEPRECATED --- //

      /**
      \deprecated
      Construct given terrain and shovel.
      \param terrain - terrain instance this collection belongs to
      \param shovel - user shovel instance
      */
      AGX_DEPRECATED(2.40.0.0)
      TerrainToolCollection(Terrain* terrain, Shovel* shovel);

      /**
      \deprecated
      \return terrain instance this collection belongs to
      */
      AGX_DEPRECATED(2.40.0.0)
      Terrain* getTerrain() const;

      /**
      \deprecated
      \return user shovel instance
      */
      AGX_DEPRECATED(2.40.0.0)
      Shovel* getShovel() const;

      /**
      \deprecated
      \return shovel active zone specific for this terrain instance
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getActiveZone)
      PrimaryActiveZone* getActiveZone() const;


      /**
      \deprecated
      \return soil particle aggregate specific for this terrain instance
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getSoilParticleAggregate)
      SoilParticleAggregate* getSoilParticleAggregate() const;


      /**
      \deprecated
      \return aggregate contact generator specific for this terrain instance
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getAggregateContactGenerator)
      AggregateContactGenerator* getAggregateContactGenerator() const;

      /**
      \deprecated
      \return aggregate contact generator specific for this terrain instance
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getDeformController)
      DeformController* getDeformController() const;


      /**
      \deprecated
      \return shovel penetration resistance specific for this terrain instance
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getPenetrationResistance)
      SoilPenetrationResistance* getPenetrationResistance() const;


      /**
      \deprecated
      \return the shovel geometries colliding with voxels in the terrain
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getVoxelCollisionGeometries)
      const agxCollide::GeometryRefVector& getVoxelCollisionGeometries() const;


      /**
      \deprecated
      \return parent frame located at model center of the shovel
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getParentFrame)
      agx::Frame* getParentFrame() const;

      /**
      \deprecated
      \return true if initialized (initializes in addNotification) - otherwise false
      */
      AGX_DEPRECATED(2.40.0.0)
      agx::Bool initialized() const;

      /**
      \deprecated
      \return true if the ToolCollection should update in preCollide, pre and post
      */
      AGX_DEPRECATED(2.40.0.0)
      agx::Bool shouldUpdate();

      /**
      \deprecated
      Set if regular geometry contacts should be created between the shovel
      geometries and the associated terrain geometry.
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::setEnableShovelTerrainGeometryContacts)
      void setEnableShovelTerrainGeometryContacts(bool enable);

      /**
      \deprecated
      Set whenever the innerbody aggregate should have zero velocity before solve step as
      opposed to using particle or cached post-solve velocities from the previous time step.
      \param enable - true if the innerbody aggregate should have zero velocity, false otherwise.
      */
      AGX_DEPRECATED_FOR(2.40.0.0, AdvancedShovelSettings::setUseZeroAggregateVelocity)
      void setZeroAggregateVelocity(bool enable);


      /*
      \deprecated
      Set whenever custom friction models should be used in the
      shovel <-> aggregate contacts.
      \param enable - True if custom friction models should be used. (Default: true)
      */
      AGX_DEPRECATED_FOR(2.40.0.0, AdvancedShovelSettings::setUseCustomFrictionModel)
      void setUseCustomFrictionModel(bool enable);

      /**
      \deprecated
      \return whenever custom friction models should be used in the shovel <-> aggregate contacts. (Default: true)
      */
      AGX_DEPRECATED_FOR(2.40.0.0, AdvancedShovelSettings::getUseCustomFrictionModel)
      bool getUseCustomFricionModel() const;



      /**
      \deprecated
      \return true if shovel enable has changed, mismatching the collection internal shovel enable variable
      */
      AGX_DEPRECATED(2.40.0.0)
      bool shovelEnableHasChanged() const;

      /**
      \deprecated
      Clear the active zone wedges of the primary active zones and deformers
      */
      AGX_DEPRECATED(2.40.0.0)
      void clearActiveZoneWedges() const;

      /**
      \deprecated
      \return the current wedge aggregate in the specified collection given an excavation mode if it exists, nullptr otherwise.
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getWedgeAggregate)
      const agx::RigidBody* getWedgeAggregate(Shovel::ExcavationMode excavationMode) const;

      /**
      \deprecated
      \return the current wedge aggregate depth in the specified collection given an excavation mode.
      */
      AGX_DEPRECATED_FOR(2.40.0.0, Shovel::getAggregateTerrainContactDepth)
      agx::Real getAggregateTerrainContactDepth(Shovel::ExcavationMode excavationMode) const;

      /**
      \deprecated
      Force re-computation of the inner shape
      */
      AGX_DEPRECATED_FOR(2.40.0.0, PrimaryActiveZone::updateInnerShape)
      void recomputeInnerShape();


      DOXYGEN_START_INTERNAL_BLOCK()

      // --- USED FOR RESTORE FROM OLD ARCHIVES --- //

      /**
      Only used internally for restore of old archives pre shovel refactor.
      \return terrain instance this collection belongs to
      */
      Terrain* getRestoredTerrain() const;

      /**
      Only used internally for restore of old archives pre shovel refactor.
      \return user shovel instance
      */
      Shovel* getRestoredShovel() const;

      /**
      Only used internally for restore of old archives pre shovel refactor.
      \return the ShovelAggregateContactMaterialContainer that contains all contact materials explicitly set for
              this tool collection.
      */
      ShovelAggregateContactMaterialContainer* getRestoredShovelTerrainContactMaterialContainer();

      /**
      Signifies whether the pair shovel<->terrain should interact
      Only used internally for restore of old archives pre shovel refactor.
      \return true if the ToolCollection is enabled
      */
      bool getRestoredEnable();

      /**
      Only used internally for restore of old archives pre shovel refactor.
      \return true if the innerbody aggregate should have zero velocity, false otherwise.
      */
      agx::Bool getRestoredSetZeroAggregateVelocity() const;

      AGXSTREAM_DECLARE_SERIALIZABLE(agxTerrain::deprecated::TerrainToolCollection);

      DOXYGEN_END_INTERNAL_BLOCK()

    protected:
      /**
      Default constructor used in serialization.
      */
      TerrainToolCollection();

      /**
      Reference counted object - protected destructor.
      */
      virtual ~TerrainToolCollection();

      enum StateFlags : agx::UInt32
      {
        ENABLED = 1 << 0,
        SHOVEL_ENABLED = 1 << 1,
        SET_ZERO_AGGREGATE_VELOCITY = 1 << 2
      };
      using Flags = agx::BitState<StateFlags, agx::UInt32>;

    private:
      Terrain* m_terrain;
      ShovelRef                                  m_shovel;
      ShovelAggregateContactMaterialContainerRef m_shovelAggregateCMContainer;
      Flags                                      m_flags;
    };
  }
}
