/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/TriaxialSignalSystemNode.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( GyroscopeSignalAssembler );

  /**
  Assembles the initial unmodified gyroscope signal.
  */
  class AGXSENSOR_EXPORT GyroscopeSignalAssembler : public SystemNode,
                                                    public ITriaxialSignalCarrier
  {
    public:
      /**
      Default constructor.
      */
      GyroscopeSignalAssembler() = default;

      /**
      \return the triaxial signal produced by this gyroscope signal assembler
      */
      virtual const std::vector<agx::Vec3>& getTriaxialSignal() const override;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      virtual void result( const CallbackData& data ) override;
      virtual void cleanup() override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::GyroscopeSignalAssembler );

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      std::vector<agx::Vec3> m_signal{};
  };
}
