/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once
#include <memory>
#include <tuple>
#include <openplx/Simulation/Simulation_all.h>
#include <click/Server.h>
#include <agxOpenPLX/SignalQueue.h>
#include <agxOpenPLX/ClickInputListener.h>
#include <agxOpenPLX/ClickOutputListener.h>
#include <agxOpenPLX/OutputSignalListener.h>

namespace agxopenplx {
    class AGXOPENPLX_EXPORT ClickAdapter {
        public:
            /**
             * @brief create and add click listeners to app once and simulation on every call
             */
            void add_listeners(agxSDK::Simulation* simulation,
                const std::string& click_server_addr,
                const std::shared_ptr<openplx::Core::Object>& openplx_scene,
                std::shared_ptr<InputSignalQueue> input_queue,
                std::shared_ptr<OutputSignalQueue> output_queue,
                OutputSignalListener* output_signal_listener,
                double time_step,
                bool auto_stepping
            );

            /**
             * @brief Sends a reset message to client next time scene is reloaded - WILL CANCEL WHATEVER OTHER MESSAGE WAS GOING TO BE SENT
             */
            virtual void sendResetMessage();
            virtual bool willSendResetMessage();

            bool manualPreFrame(const agx::TimeStamp& timestamp);
            virtual std::shared_ptr<agxopenplx::ClickInputListener> createClickInputListener(
                const std::shared_ptr<openplx::Core::Object> &openplx_scene,
                std::shared_ptr<InputSignalQueue> input_queue,
                double time_step,
                bool auto_stepping);
            virtual ~ClickAdapter() = default;

        protected:
            std::shared_ptr<click::Server> m_server;
            std::shared_ptr<ClickInputListener> m_click_input_listener;
            bool m_send_reset_message = false;
            ClickOutputListener * m_click_output_listener;
            OutputSignalListener * m_output_signal_listener;
    };
}
