// Copyright 2022, Algoryx Simulation AB.

#pragma once

// Wheel Loader includes.
#include "DriveTrain.h"

// AGX Dynamics for Unreal includes.
#include "AGX_SceneComponentReference.h"

// Unreal Engine includes.
#include "Components/ActorComponent.h"

#include "DWL_DriveTrainComponent.generated.h"

/**
 * A component that triggers the creation of a wheel loader drive-train.
 *
 * Also provides Blueprint callable functions for runtime manipulation from user input, such as to
 * set the engine throttle or gear switching.
 */
UCLASS(ClassGroup = "Wheel Loader", Category = "Wheel Loader", Meta = (BlueprintSpawnableComponent))
class WHEELLOADER_API UDWL_DriveTrainComponent : public UActorComponent
{
	GENERATED_BODY()

public:
	UDWL_DriveTrainComponent();

	// Generic SceneComponentReferences are used to point to the wheel hinges because we don't get
	// have a type specific yet flexible way to create component references. These must all be set
	// to point to the wheel hinges and nothing else!

	UPROPERTY(EditAnywhere, Category = "Wheel Loader")
	FAGX_SceneComponentReference FrontLeftWheelHinge;

	UPROPERTY(EditAnywhere, Category = "Wheel Loader")
	FAGX_SceneComponentReference FrontRightWheelHinge;

	UPROPERTY(EditAnywhere, Category = "Wheel Loader")
	FAGX_SceneComponentReference RearLeftWheelHinge;

	UPROPERTY(EditAnywhere, Category = "Wheel Loader")
	FAGX_SceneComponentReference RearRightWheelHinge;

public:
	UFUNCTION(BlueprintCallable)
	void SetGear(int32 Gear);

	UFUNCTION(BlueprintCallable)
	int32 GetGear();

	UFUNCTION(BlueprintCallable)
	void SetThrottle(float Throttle);

	UFUNCTION(BlueprintCallable)
	float GetThrottle();

	UFUNCTION(BlueprintCallable)
	float GetRpm();

public:
	// ~Begin UActorComponent interface.
	virtual void BeginPlay() override;
	// ~End UActorComponent interface.


private:
	FDriveTrainUtilities::FDriveTrainId DriveTrainId;
};
