// Copyright 2022, Algoryx Simulation AB.

#pragma once

#include "RobotTarget.h"

// Unreal Engine includes.
#include "CoreMinimal.h"
#include "Kismet/BlueprintFunctionLibrary.h"

#include "RobotSequence.generated.h"

UENUM()
enum ESequenceType
{
	DominoLeft = 1 UMETA(DisplayName = "DominoLeftArm"),
	DominoRightArm = 2 UMETA(DisplayName = "DominoRightArm")
};

USTRUCT(BlueprintType)
struct YUMI_API FRobotSequence
{
	GENERATED_USTRUCT_BODY()

	void SetType(TEnumAsByte<enum ESequenceType> InSequenceType);

	TArray<FRobotTarget>& GetTargets();

private:
	TArray<FRobotTarget> Targets;
	TEnumAsByte<enum ESequenceType> SequenceType;
};

/**
 * This class acts as an API that exposes functions of ESequenceType in Blueprints.
 */
UCLASS()
class YUMI_API URobotSequence_FL : public UBlueprintFunctionLibrary
{
	GENERATED_BODY()

	UFUNCTION(BlueprintCallable, Category = "Controller")
	static FRobotSequence& SetType(
		UPARAM(ref) FRobotSequence& Sequence, TEnumAsByte<enum ESequenceType> InSequenceType)
	{
		Sequence.SetType(InSequenceType);
		return Sequence;
	};
};
