// Copyright 2022, Algoryx Simulation AB.

using UnrealBuildTool;
using System.Collections.Generic;

public class YumiEditorTarget : TargetRules
{
	public YumiEditorTarget(TargetInfo Target) : base(Target)
	{
		Type = TargetType.Editor;

		// From time to time the default build settings are changed and new
		// settings are added. For compatibility with user projects we want to
		// be as current as possible. Setting 'Latest' will make it so that we
		// use whatever build settings are suitable for the Unreal Engine
		// version currently being built for. If there are breaking changes
		// between Unreal Engine versions that we should support then we can
		// either pin a particual V# (V3, V4, V5, etc.) here until the older
		// Unreal Engine version is no longer supported, or do some other kind
		// of workaround depending on the specifics of what changed.
		DefaultBuildSettings = BuildSettingsVersion.Latest;
		IncludeOrderVersion = EngineIncludeOrderVersion.Latest;

		ExtraModuleNames.AddRange(new string[] { "Yumi" });
	}
}
